//%attributes = {}
// Method: ld_ TRACK_TIME_GRAPH_DRAW 
// 01.06.12, 19:14:57 / MG_AK
// © Copyright Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_POINTER:C301($1; $ld_pPict)
C_LONGINT:C283($2; $ld_lStatus; $3; $ld_lSelected)
C_TEXT:C284($ld_tSvgRef; $ld_tSvgObject)
C_TEXT:C284($ld_tForegroundColor; $ld_tBackgroundColor)
C_REAL:C285($ld_rGraphWidth; $ld_rGraphHeigth; $ld_rRadius; $ld_rStrokeWidth)
$ld_pPict:=$1
$ld_lStatus:=$2
$ld_lSelected:=$3

Case of 
	: ($ld_lStatus=-1)
		$ld_tForegroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorCheckNotAllowed")
		$ld_tBackgroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorCheckNotAllowedBack")
	: (($ld_lSelected=kFalse) & ($ld_lStatus=1))
		$ld_tForegroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorRequest")
		$ld_tBackgroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorRequestBack")
	: (($ld_lSelected=kTrue) & ($ld_lStatus=1))
		$ld_tForegroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorRequestSelected")
		$ld_tBackgroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorRequestSelectedBack")
		
	: (($ld_lSelected=kFalse) & ($ld_lStatus=2))
		$ld_tForegroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorEntered")
		$ld_tBackgroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorEnteredBack")
	: (($ld_lSelected=kTrue) & ($ld_lStatus=2))
		$ld_tForegroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorEnteredSelected")
		$ld_tBackgroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorEnteredSelectedBack")
		
	: (($ld_lSelected=kFalse) & ($ld_lStatus=3))
		$ld_tForegroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorCheckDone")
		$ld_tBackgroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorCheckDoneBack")
	: (($ld_lSelected=kTrue) & ($ld_lStatus=3))
		$ld_tForegroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorCheckDoneSelected")
		$ld_tBackgroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorCheckDoneSelectedBack")
		
	: (($ld_lSelected=kFalse) & ($ld_lStatus=4))
		$ld_tForegroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorCheckNotDone")
		$ld_tBackgroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorCheckNotDoneBack")
	: (($ld_lSelected=kTrue) & ($ld_lStatus=4))
		$ld_tForegroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorCheckNotDoneSelected")
		$ld_tBackgroundColor:=_prf_ JsonText(<>ld_tTrackTimeGraphPrf; "ColorCheckNotDoneSelectedBack")
		
		
	Else 
		$ld_tForegroundColor:="-1"
End case 

If ($ld_tForegroundColor="-1")
	$ld_pPict->:=$ld_pPict->*0  // clear picture
Else 
	
	If ($ld_tBackgroundColor="")
		$ld_tBackgroundColor:=$ld_tForegroundColor
	End if 
	$ld_rGraphWidth:=_prf_ JsonNum(<>ld_tTrackTimeGraphPrf; "GraphWidth")
	$ld_rGraphHeigth:=_prf_ JsonNum(<>ld_tTrackTimeGraphPrf; "GraphHeigth")
	$ld_rRadius:=_prf_ JsonNum(<>ld_tTrackTimeGraphPrf; "CircleRadius")
	$ld_rStrokeWidth:=_prf_ JsonNum(<>ld_tTrackTimeGraphPrf; "StrokeWidth")
	
	$ld_tSvgRef:=SVG_New($ld_rGraphWidth; $ld_rGraphHeigth)
	$ld_tSvgObject:=SVG_New_rect($ld_tSvgRef; 0; 0; $ld_rGraphWidth; $ld_rGraphHeigth; 0; 0; <>ld_tGraphBackgroundColor; <>ld_tGraphBackgroundColor; 0)  // grey background, otherwise would be white
	
	//  BackgroundColor is different for mac / win / ( win7 ? )
	$ld_tSvgObject:=SVG_New_circle($ld_tSvgRef; $ld_rGraphWidth/2; $ld_rGraphHeigth/2; $ld_rRadius; $ld_tForegroundColor; $ld_tBackgroundColor; $ld_rStrokeWidth)  // grey background, otherwise would be white
	SVG EXPORT TO PICTURE:C1017($ld_tSvgRef; $ld_pPict->; Own XML data source:K45:18)
	//SVG_CLEAR ($ld_tSvgRef)// may not use id Own XML Data Source is used
	
End if 